
public class DirectFieldAccessDangers 
{
	//FIELDS are statically typed.  This is one of the many
	//reasons why you should NEVER make fields public!
	public static void main(String[] args)
	{
		B objB = new B();
		//upcasting: upcasting is always "safe" from the java compiler,
		//so you don't need to do an explicit cast.
		//perspective...
		A objB_v2 = objB;
		//...but you can only use a method available to the static type.
		//to access the dynamic type, you need to have a static type
		//that can access this method (casting!)
		//you can see this by trying to call getBothMsgs() with objB_v2.
		
		System.out.println("\nFields are statically typed!");
		System.out.println("Obj with static type A: "+objB.myMsg);
		System.out.println("Obj with static type B: "+objB_v2.myMsg);
		
		
		System.out.println("\nMethods are dynamically typed, but access the " +
		"field in the type where the method is defined.");
		System.out.println("Obj with static type A: "+objB.getMyMsg());
		System.out.println("Obj with static type B: "+objB_v2.getMyMsg());
		
		B objC_staticTypeB = new C();
		//upcasting
		A objC_staticTypeA = objC_staticTypeB;
		//downcasting: gives you access to methods in the 
		C objC_staticTypeC = (C)objC_staticTypeB;
		System.out.println("\nFields are statically typed!");
		System.out.println("Obj with static type A: "+objC_staticTypeA.myMsg);
		System.out.println("Obj with static type B: "+objC_staticTypeB.myMsg);
		System.out.println("Obj with static type C: "+objC_staticTypeC.myMsg);
		
		System.out.println("\nMethods are dynamically typed, but access the " +
		"field in the type where the method is defined.");
		System.out.println("Obj with static type A: "+objC_staticTypeA.getMyMsg());
		System.out.println("Obj with static type B: "+objC_staticTypeB.getMyMsg());
		System.out.println("Obj with static type C: "+objC_staticTypeC.getMyMsg());
		
		objC_staticTypeC.setMyMsg("New message!");
		System.out.println("\nFields are statically typed!");
		System.out.println("Obj with static type A: "+objC_staticTypeA.myMsg);
		System.out.println("Obj with static type B: "+objC_staticTypeB.myMsg);
		System.out.println("Obj with static type C: "+objC_staticTypeC.myMsg);
		
		System.out.println("\nMethods are dynamically typed, but access the " +
		"field in the type where the method is defined.");
		System.out.println("Obj with static type A: "+objC_staticTypeA.getMyMsg());
		System.out.println("Obj with static type B: "+objC_staticTypeB.getMyMsg());
		System.out.println("Obj with static type C: "+objC_staticTypeC.getMyMsg());
		
		System.out.println("\n");
		objC_staticTypeC.printSpecialMsg();
	}
	
}
class A
{
	public String myMsg;
	public A()
	{
		myMsg = "I am an A.";
	}
	public String getMyMsg()
	{
		return myMsg;
	}
	public void setMyMsg(String newMsg)
	{
		myMsg = newMsg;
	}
}
class B extends A
{
	//this is BAD--it shadows the name of the parent variable, "A".
	public String myMsg;
	public B()
	{
		myMsg = "I am a B.";
	}
	public String getBothMsgs()
	{
		return super.myMsg + " "+this.myMsg;
	}
}

class C extends B
{
	public String myMsg;
	public C()
	{
		myMsg = "I am a C.";
	}
	public String getMyMsg()
	{
		return "Overriding parent!" + myMsg;
	}
	public void printSpecialMsg()
	{
		System.out.println("Takeaway message: make your fields private, use getters and setters,\n " +
				           "and when writing a subclass, pretend you don't know anything about the \n" +
				           "private variables in the parent!");
	}
}